<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

if (file_exists(__DIR__.'/.env')) {
    define('IS_DEV', true);
    define("PROJECT_DIR", "/mnt/d/_wans/_code/games/furba/www");
    define('PROJECT_PATH', '/furba/www');
} else {
    define('IS_DEV', false);
    define("PROJECT_DIR", "/var/www/html/dev"); // projects/furba
    define('PROJECT_PATH', '/dev'); //projects/furba
}

define('API_PATH', PROJECT_PATH . '/api');
define('HELPERS_DIR', PROJECT_DIR .'/api/helpers');

define('USER_LANGUAGES', [
    'EN'=>'English',
    'IT'=>'Italiano',
    'TR'=>'Türkçe',
    'RU'=>'Русский',
    'CN'=>'中文',
    'HI'=>'हिंदी'
]);

require_once HELPERS_DIR. '/SessionHelper.php';

define('USER_LANGUAGE', SessionHelper::get('language', 'EN'));

require_once HELPERS_DIR. '/I18nHelper.php';
require_once HELPERS_DIR. '/ToolsHelper.php';
require_once HELPERS_DIR. '/TokenHelper.php';
require_once HELPERS_DIR. '/UserAuthorizer.php';
require_once HELPERS_DIR. '/UserManager.php';
require_once HELPERS_DIR. '/ProfileManager.php';
require_once HELPERS_DIR. '/SubscriptionsHelper.php';


require_once 'data/countries.php';
require_once 'data/leaders.php';

require_once 'data/roles.php';