<?php
class SubscriptionsHelper {
    /**
     * PDO database connection
     * @var PDO
     */
    private $pdo;

    /**
     * Constructor to establish database connection
     */
    public function __construct() {
        // Define the database file path
        $dbFile = PROJECT_DIR . '/data/users.db';

        // Ensure the database file exists
        if (!file_exists($dbFile)) {
            throw new Exception("Database file not found");
        }

        // Create a PDO connection to the SQLite database
        $this->pdo = new PDO("sqlite:$dbFile");
        $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    }

    /**
     * Fetch user subscription details by user ID
     *
     * @param int $userId User's unique identifier
     * @return array|false Subscription details or false if not found
     */
    public function getSubscriptions($subscriptionId) {
        // Validate user ID
        if (!$subscriptionId) {
            throw new Exception("Invalid subscription ID");
        }

        // Prepare SQL to fetch subscription details
        $stmt = $this->pdo->prepare("
            SELECT *
            FROM subscriptions
            WHERE subscription_id = :subscriptionId
        ");

        // Execute the query
        $stmt->execute(['subscriptionId' => $subscriptionId]);

        // Fetch the subscription details
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function getUserSubscription($userId) {
        // Validate user ID
        if (!$userId) {
            throw new Exception("Invalid ID");
        }

        // Prepare SQL to fetch subscription details
        $stmt = $this->pdo->prepare("
            SELECT *
            FROM subscriptions
            WHERE user_id = :userId
        ");

        // Execute the query
        $stmt->execute(['userId' => $userId]);

        // Fetch the subscription details
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }


}