<?php

class I18n {
    public static function get($value = '', $lang = USER_LANGUAGE): mixed {
        if (empty($value)) return $value;
        return self::$Dict[$value][$lang]?? $value;
    }

    private static $Dict = [

        'Login' => [
            'EN' => 'Login',
            'RU' => 'Войти',
            'CN' => '登录',
        ],

        'Logout' => [
            'EN' => 'Logout',
            'RU' => 'Выйти',
            'CN' => '注销',
        ],

        'Username' => [
            'EN' => 'Username',
            'RU' => 'Имя пользователя',
            'CN' => '用户名',
        ],

        'Password' => [
            'EN' => 'Password',
            'RU' => 'Пароль',
            'CN' => '用户密码',
        ],

        'Profile' => [
            'EN' => 'Profile',
            'RU' => 'Кабинет',
            'CN' => '个人资料',
        ],

        'Gallery' => [
            'EN' => 'Gallery',
            'RU' => 'Галерея',
            'CN' => '画廊',
        ],

        'Pricing' => [
            'EN' => 'Pricing',
            'RU' => 'Тарифы',
            'CN' => '关税',
        ],

        'About Us' => [
            'EN' => 'About Us',
            'RU' => 'О нас',
            'CN' => '关于我们',
        ],

        'HelperHeader' => [
            'EN' => 'Tap to find out',
            'RU' => 'Нажмите, чтобы узнать',
            'CN' => '点击了解详情',
        ],

        'HelperSub' => [
            'EN' => 'Use artificial intelligence to create shoes for your production!',
            'RU' => 'Используйте искусственный интеллект для создания обуви для вашего производства!',
            'CN' => '使用人工智能为您的生产创造鞋子！',
        ],

        'Try for free' => [
            'EN' => 'Try for free',
            'RU' => 'Попробуйте',
            'CN' => '免费试用',
        ],

        'Step 1' => [
            'EN' => 'Step 1',
            'RU' => 'Шаг 1',
            'CN' => '第1步',
        ],

        'Choose template' => [
            'EN' => 'Choose template',
            'RU' => 'Выберите основу',
            'CN' => '选择模板',
        ],

        'Step1Sub' => [
            'EN' => 'Choose the design you want your version of the shoe based on! '.
                'You will receive a unique design just for you!',
            'RU' => 'Выберите дизайн обуви, который вы хотите взять за основу! '.
                'Вы получите уникальный дизайн только для вас!',
            'CN' => '选择您想要基于的鞋子设计！'.
                '您将获得一个专属于您的独特设计！',
        ],

        'All' => [
            'EN' => 'All',
            'RU' => 'Все',
            'CN' => '所有',
        ],

        'Men' => [
            'EN' => 'Men',
            'RU' => 'Мужская',
            'CN' => '男性',
        ],

        'Women' => [
            'EN' => 'Women',
            'RU' => 'Женская',
            'CN' => '女性',
        ],

        'Kids' => [
            'EN' => 'Kids',
            'RU' => 'Детская',
            'CN' => '儿童',
        ],

// ==================================================================================

        'Step 2' => [
            'EN' => 'Step 2',
            'RU' => 'Шаг 2',
            'CN' => '第2步',
        ],

        'Choose part' => [
            'EN' => 'Choose part',
            'RU' => 'Выберите часть',
            'CN' => '选择部件',
        ],

        'Sole' => [
            'EN' => 'Sole',
            'RU' => 'Подошва',
            'CN' => '鞋底',
        ],

        'SoleSub' => [
            'EN' => 'A new sole will be generated for the selected shoes.',
            'RU' => 'Для выбранной обуви будет сгенерирована новая подошва.',
            'CN' => '将为所选鞋子生成新的鞋底。',
        ],

        'Upper' => [
            'EN' => 'Upper',
            'RU' => 'Верх',
            'CN' => '鞋面',
        ],

        'UpperSub' => [
            'EN' => 'A new upper will be generated for the selected shoes.',
            'RU' => 'Для выбранной обуви будет сгенерирован новый верх.',
            'CN' => '将为所选鞋子生成新的鞋面。',
        ],

        'Complete' => [
            'EN' => 'Complete',
            'RU' => 'Полностью',
            'CN' => '完成',
        ],

        'CompleteSub' => [
            'EN' => 'A new design will be generated for the selected model.',
            'RU' => 'Будет сгенерирован новый дизайн для выбранной модели.',
            'CN' => '将为所选模型生成新的设计。',
        ],


// ====================================================================

        'left' => [
            'EN' => 'left',
            'RU' => 'осталось',
            'CN' => '剩余',
        ],
    ];

}