<?php
namespace Services;

class GPUClient {
    private const SD_BASE_ASYNC_URL_V002    = "https://api.runpod.ai/v2/%s/run";
    private const SD_STATUS_URL_V002        = "https://api.runpod.ai/v2/%s/status/";
    private const SD_SERVERLESS_API_ID_V002 = "7nbmvzklzmass5"; //"uv2b11cktmmo45";
    private const SD_API_KEY_V002           = "rpa_66CPZFC33GAYXHDC8PVXSRYU7J67SHOOXYCR5SLBpzp32c"; //"3R15P33SCEXKU3RF7GBRJQJ3PER349HZQGRXW9HZ";
    private const SD_MODEL_V002             = "Markelangelo.safetensors";
    private const SD_VAE_V002               = "color101VAE_v1.safetensors";
    private const SD_CONTROLNET_V002        = "control_v11p_sd15_inpaint.pth";
    private const SD_DEFAULT_STEPS_V002     = 25; //40 too long
    private const SD_DEFAULT_CFG_V002       = 9;
    private const SD_DEFAULT_DENOISE_V002   = 0.75;
    private const SD_DEFAULT_SAMPLER_V002   = "ddim";
    private const SD_DEFAULT_SHEDULER_V002  = "karras";
    private const WF21_POSITIVE_PROMPT_KEY  = "21";
    private const WF22_NEGATIVE_PROMPT_KEY  = "22";
    private const WF35_INITIAL_IMAGE_KEY    = "35";
    private const WF35_INITIAL_IMAGE_NAME   = "initial_image.png";
    private const WF178_MASK_IMAGE_KEY      = "178";
    private const WF178_MASK_IMAGE_NAME     = "mask_image.png";

    private static $baseRequestTemplate = [
        "input" => [
            "workflow" => [
                "19" => [
                    "inputs"     => ["ckpt_name" => self::SD_MODEL_V002],
                    "class_type" => "CheckpointLoaderSimple",
                    "_meta"       => ["title" => "Load Checkpoint"]
                ],
                "20" => [
                    "inputs"     => [
                        "model"    => ["19", 0],
                        "clip"     => ["19", 1],
                        "vae"      => ["25", 0],
                        "positive" => ["45", 0],
                        "negative" => ["45", 1],
                    ],
                    "class_type" => "ToBasicPipe",
                    "_meta"       => ["title" => "ToBasicPipe"]
                ],
                self::WF21_POSITIVE_PROMPT_KEY => [
                    "inputs"     => [
                        "text" => null,
                        "clip" => ["19", 1]
                    ],
                    "class_type" => "CLIPTextEncode",
                    "_meta"       => ["title" => "CLIP Positive"]
                ],
                self::WF22_NEGATIVE_PROMPT_KEY => [
                    "inputs"     => [
                        "text" => null,
                        "clip" => ["19", 1]
                    ],
                    "class_type" => "CLIPTextEncode",
                    "_meta"       => ["title" => "CLIP Negative"]
                ],
                "25" => [
                    "inputs"     => ["vae_name" => self::SD_VAE_V002],
                    "class_type" => "VAELoader",
                    "_meta"       => ["title" => "Load VAE"]
                ],
                "30" => [
                    "inputs"     => [
                        "seed"         => null,  // динамическое значение
                        "steps"        => self::SD_DEFAULT_STEPS_V002,
                        "cfg"          => self::SD_DEFAULT_CFG_V002,
                        "sampler_name" => self::SD_DEFAULT_SAMPLER_V002,
                        "scheduler"    => self::SD_DEFAULT_SHEDULER_V002,
                        "denoise"      => self::SD_DEFAULT_DENOISE_V002,
                        "basic_pipe"   => ["20", 0],
                        "latent_image" => ["84", 0],
                    ],
                    "class_type" => "ImpactKSamplerBasicPipe",
                    "_meta"       => ["title" => "KSampler (pipe)"]
                ],
                "32" => [
                    "inputs"     => [
                        "samples" => ["30", 1],
                        "vae"     => ["30", 2],
                    ],
                    "class_type" => "VAEDecode",
                    "_meta"       => ["title" => "VAE Decode"]
                ],
                "34" => [
                    "inputs"     => [
                        "pixels" => ["35", 0],
                        "vae"    => ["25", 0],
                    ],
                    "class_type" => "VAEEncode",
                    "_meta"       => ["title" => "VAE Encode"]
                ],

                self::WF35_INITIAL_IMAGE_KEY => [
                    "inputs"     => [
                        "image" => self::WF35_INITIAL_IMAGE_NAME,
                        "upload" => "image"
                    ],
                    "class_type" => "LoadImage",
                    "_meta"       => ["title" => "Load Init Image"]
                ],
                "39" => [
                    "inputs"     => ["control_net_name" => self::SD_CONTROLNET_V002],
                    "class_type" => "ControlNetLoader",
                    "_meta"       => ["title" => "Load ControlNet Model"]
                ],

                "45" => [
                    "inputs"     => [
                        "strength"      => 1,
                        "start_percent" => 0,
                        "end_percent"   => 1,
                        "positive"      => ["21", 0],
                        "negative"      => ["22", 0],
                        "control_net"   => ["39", 0],
                        "image"         => ["91", 0],
                    ],
                    "class_type" => "ControlNetApplyAdvanced",
                    "_meta"       => ["title" => "Apply ControlNet"]
                ],
                "84" => [
                    "inputs"     => [
                        "amount"  => 1,
                        "samples" => ["90", 0],
                    ],
                    "class_type" => "RepeatLatentBatch",
                    "_meta"       => ["title" => "Repeat Latent Batch"]
                ],
                "90" => [
                    "inputs"     => [
                        "samples" => ["34", 0],
                        "mask"    => ["178", 1],
                    ],
                    "class_type" => "SetLatentNoiseMask",
                    "_meta"       => ["title" => "Set Latent Noise Mask"]
                ],
                "91" => [
                    "inputs"     => [
                        "black_pixel_for_xinsir_cn" => false,
                        "image"                     => ["35", 0],
                        "mask"                      => ["178", 1],
                    ],
                    "class_type" => "InpaintPreprocessor",
                    "_meta"       => ["title" => "Inpaint Preprocessor"]
                ],
                "110" => [
                    "inputs"     => ["image" => ["32", 0]],
                    "class_type" => "ImpactImageBatchToImageList",
                    "_meta"       => ["title" => "Image Batch to Image List"]
                ],
                "175" => [
                    "inputs"     => [
                        "filename_prefix" => "FURBA",
                        "images"        => ["110", 0],
                    ],
                    "class_type" => "SaveImage",
                    "_meta"       => ["title" => "Save Image"]
                ],
                self::WF178_MASK_IMAGE_KEY => [
                    "inputs"     => [
                        "image" => self::WF178_MASK_IMAGE_NAME,  // Added missing image filename reference
                        "upload" => "image"         // Added required upload type parameter
                    ],
                    "class_type" => "LoadImage",
                    "_meta"       => ["title" => "Load Mask Image"]
                ],
            ],
            "images" => []
        ]
    ];

    /**
     * Логирует запрос к runpod с данными URL, заголовками и телом запроса.
     *
     * @param string $url URL запроса.
     * @param array $headers Заголовки запроса.
     * @param string $body Тело запроса.
     * @return void
     */
    private static function logRunpodRequest(string $url, array $headers, string $body = ''): void {
        // Формируем сообщение лога с меткой времени
        $logMessage = \sprintf(
            "[%s] Request URL: %s\nHeaders: %s\nBody: %s\n\n",
            date("Y-m-d H:i:s"),
            $url,
            \json_encode($headers),
            $body
        );

        $file_id = md5(json_encode($logMessage));
        // Сохраняем данные в лог-файл (добавляем в конец файла)
        \file_put_contents(__DIR__ . '/logs/runpod_'.md5(microtime()).'_'.$file_id.'.log', $logMessage);
    }

    /**
     * Создаёт базовый запрос с подстановкой динамического значения seed.
     * $images = [
     *      ['name' => 'initial_image.png', 'image' => $initImageBase64],
     *      ['name' => 'mask_image.png',    'image' => $maskImageBase64]
     * ];
     *
     * @param int $seed Значение seed.
     * @return array Массив запроса.
     * @throws \Exception В случае ошибки.
     */
    public static function createRequest(int $seed, array $prompts = [], array $images = []): array {

        if (empty($images)) {
            throw new \Exception('Images array is empty.');
        }
        if (count($images) < 2) {
            throw new \Exception('Images array must contain at least two elements.');
        }
        if (empty($prompts)) {
            throw new \Exception('Prompts array is empty.');
        }
        if (empty($prompts['POSITIVE_PROMPT'])) {
            throw new \Exception('Prompts array must contain at least POSITIVE prompt.');
        }

        // Выполняем глубокое клонирование шаблона
        $request = json_decode(json_encode(self::$baseRequestTemplate), true);
        $request['input']['workflow']['30']['inputs']['seed'] = $seed;

        $request['input']['workflow'][self::WF21_POSITIVE_PROMPT_KEY]['inputs']['text'] = $prompts['POSITIVE_PROMPT'] ?? null;
        $request['input']['workflow'][self::WF22_NEGATIVE_PROMPT_KEY]['inputs']['text'] = $prompts['NEGATIVE_PROMPT'] ?? null;

        $request['input']['workflow'][self::WF35_INITIAL_IMAGE_KEY]['inputs']['image'] = $images[0]['name'];
        $request['input']['workflow'][self::WF178_MASK_IMAGE_KEY]['inputs']['image'] = $images[1]['name'];

        $request['input']['images'] = $images;
        return $request;
    }


    /**
     * Отправляет JSON-запрос через cURL.
     *
     * @param array $request Массив запроса.
     * @return array Декодированный JSON-ответ.
     * @throws \Exception В случае ошибки.
     */
    public static function sendRequest(array $request): array {
        $url = sprintf(self::SD_BASE_ASYNC_URL_V002, self::SD_SERVERLESS_API_ID_V002);
        // Преобразуем запрос в JSON для отправки и логирования
        $jsonRequest = json_encode($request);

        $requestHeaders = [
            'Content-Type: application/json',
            'Authorization: Bearer ' . self::SD_API_KEY_V002
        ];

        self::logRunpodRequest($url, $requestHeaders, $jsonRequest);

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // Указываем версию TLS (если сервер требует именно TLS 1.2)
        curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);

        // Для диагностики (только на локальной машине! На проде проверку отключать не рекомендуется)
        //curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        //curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

        // Включаем подробный вывод (можно отключить после диагностики)
        //curl_setopt($ch, CURLOPT_VERBOSE, true);

        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $requestHeaders);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonRequest);
        $result = curl_exec($ch);
        if ($result === false) {
            $error = curl_error($ch);
            curl_close($ch);
            throw new \Exception("cURL error: " . $error);
        }
        curl_close($ch);
        return json_decode($result, true);
    }

    /**
     * Проверяет статус задания по его ID.
     *
     * @param string $jobId ID задания.
     * @return array Декодированный JSON-ответ.
     * @throws \Exception В случае ошибки.
     */
    public static function checkStatus(string $jobId): array {
        $url = sprintf(self::SD_STATUS_URL_V002, self::SD_SERVERLESS_API_ID_V002) . $jobId;
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: Bearer ' . self::SD_API_KEY_V002,
            'Content-Type: application/json',
            'Access-Control-Allow-Origin: *',
            'Access-Control-Allow-Methods: GET, POST, OPTIONS',
            'Access-Control-Allow-Headers: Content-Type, Authorization',
            'User-Agent: Mozilla/5.0' // Generic user agent
        ]);
        $result = curl_exec($ch);
        if ($result === false) {
            $error = curl_error($ch);
            curl_close($ch);
            throw new \Exception(json_encode(["error" => "cURL error: " . $error]));
        }
        curl_close($ch);
        return json_decode($result, true);
    }


    public static function postJobData(): array {
        // Retrieve raw POST input data
        $rawInput = file_get_contents('php://input');
        $inputData = [];
        if ($rawInput === false) {
            throw new \Exception("Failed to read input");
        } else {
            // Split the raw input string into key-value pairs using the '&' delimiter.
            // This will convert a URL-encoded query string to an associative array.
            \parse_str($rawInput, $inputData);
        }

        // Ensure the 'job_data' key exists
        if (!isset($inputData['job_data'])) {
            throw new \Exception("Missing 'data' in input");
        }

        // Return the job_data array
        return ['data' => $inputData['job_data']];
    }
}