<?php
$colorTable = [

    "Cyan" => ["#00FFFF", "#00CCCC", "#009999", "#006666", "#003333"],
    "Light Cyan" => ["#33FFFF", "#66FFFF", "#99FFFF", "#CCFFFF"],


   // Нейтральные цвета
   "Black" => ["#000000", "#0A0A0A", "#1A1A1A", "#2B2B2B"],
   "White" => ["#FFFFFF", "#F5F5F5", "#FAFAFA", "#F0F0F0"],
   "Light Grey" => ["#C0C0C0", "#D3D3D3", "#E0E0E0", "#EEEEEE"],
   "Dark Grey" => ["#808080", "#696969", "#555555", "#444444"],
   "Beige" => ["#F5F5DC", "#F5DEB3", "#E6D5B8", "#D2B48C"],
   "Light Beige" => ["#FAF0E6", "#FFF8DC", "#FFEBCD", "#FFEFD5"],
   "Dark Beige" => ["#CDB891", "#BC8F8F", "#A0522D", "#8B4513"],

   // Синие оттенки
   "Blue" => ["#0000FF", "#0000CC", "#000099", "#000066", "#000033"],
   "Dark Blue" => ["#000080", "#00008B", "#191970", "#1E90FF"],
   "Navy Blue" => ["#000080", "#003366", "#191970", "#1E90FF"],
   "Light Blue" => ["#ADD8E6", "#87CEEB", "#B0E0E6", "#87CEFA"],
   "Royal Blue" => ["#4169E1", "#4682B4", "#6495ED", "#1E90FF"],
   "Denim Blue" => ["#1560BD", "#1E90FF", "#6F8FAF", "#5D8AA8"],
   "Sky Blue" => ["#87CEEB", "#87CEFA", "#B0E2FF", "#A4D3EE"], // Небезопасный
   "Steel Blue" => ["#4682B4", "#5F9EA0", "#6A5ACD", "#7B68EE"], // Небезопасный

   // Красные оттенки
   "Red" => ["#FF0000", "#CC0000", "#990000", "#660000", "#330000"],
   "Light Red" => ["#FF3333", "#FF6666", "#FF9999", "#FFCCCC"],
   "Dark Red" => ["#800000", "#8B0000", "#B22222"],
   "Burgundy" => ["#800020", "#8B0000", "#722F37", "#7C0A02"],
   "Crimson" => ["#DC143C", "#B22222", "#8B0000", "#FF3030"], // Небезопасный
   "Scarlet" => ["#FF2400", "#FF4500", "#FF6347", "#FF7F50"], // Небезопасный

   // Зеленые оттенки
   "Green" => ["#00FF00", "#00CC00", "#009900", "#006600", "#003300"],
   "Light Green" => ["#33FF33", "#66FF66", "#99FF99", "#CCFFCC"],
   "Dark Green" => ["#008000", "#006400", "#228B22", "#2E8B57"],
   "Olive Green" => ["#556B2F", "#6B8E23", "#808000", "#8FBC8B"],
   "Mint Green" => ["#98FB98", "#8FBC8B", "#7FFFD4", "#66CDAA"],
   "Forest Green" => ["#228B22", "#2E8B57", "#3CB371", "#32CD32"], // Небезопасный
   "Lime Green" => ["#32CD32", "#00FF00", "#7CFC00", "#ADFF2F"], // Небезопасный

   // Коричневые оттенки
   "Brown" => ["#A52A2A", "#A0522D", "#D2691E"],
   "Light Brown" => ["#CD853F", "#DEB887", "#F4A460"],
   "Dark Brown" => ["#654321", "#8B4513", "#A0522D", "#D2691E"],
   "Chocolate" => ["#D2691E", "#8B4513", "#A0522D", "#CD853F"], // Небезопасный
   "Camel" => ["#C19A6B", "#D2B48C", "#DEB887", "#F4A460"], // Небезопасный

   // Желтые и оранжевые оттенки
   "Yellow" => ["#FFFF00", "#CCCC00", "#999900", "#666600"],
   "Light Yellow" => ["#FFFF33", "#FFFF66", "#FFFF99", "#FFFFCC"],
   "Dark Yellow" => ["#8B8B00", "#9ACD32", "#BDB76B"],
   "Mustard" => ["#FFDB58", "#FFD700", "#DAA520", "#B8860B"],
   "Orange" => ["#FFA500", "#FF8C00", "#FF7F50", "#FF6347", "#CC8400", "#996300", "#664200", "#332100"],
   "Light Orange" => ["#FFB733", "#FFC966", "#FFDB99", "#FFEDCC"],
   "Dark Orange" => ["#FF8C00", "#FF7F50", "#FF6347", "#FF4500"],

   "Coral" => ["#FF7F50", "#FF6F61", "#FF4040", "#FF4500"],
   "Gold" => ["#FFD700", "#DAA520", "#B8860B", "#FFDF00"], // Небезопасный

   // Фиолетовые и розовые оттенки
   "Purple" => ["#800080", "#8B008B", "#9932CC", "#8A2BE2"],
   "Lavender" => ["#E6E6FA", "#D8BFD8", "#DDA0DD", "#EE82EE"],
   "Violet" => ["#8A2BE2", "#9400D3", "#9932CC", "#8B008B"], // Небезопасный

   "Pink" => ["#FFC0CB", "#FF69B4", "#FF1493", "#DB7093"],
   "Light Pink" => ["#FFB6C1", "#FFC0CB", "#FFDAB9", "#FFE4E1"],
   "Dark Pink" => ["#C71585", "#DA70D6", "#D8BFD8", "#DDA0DD"],

   "Light Purple" => ["#9370DB", "#BA55D3", "#DA70D6", "#DDA0DD"],
   "Dark Purple" => ["#4B0082", "#483D8B", "#6A5ACD", "#7B68EE"],
   "Magenta" => ["#FF00FF", "#CC00CC", "#990099", "#660066", "#330033", "#FF00FF"], // Небезопасный
   "Light Magenta" => ["#FF33FF", "#FF66FF", "#FF99FF", "#FFCCFF"],

   // Другие популярные цвета
   "Teal" => ["#008080", "#008B8B", "#20B2AA", "#48D1CC"],
   "Turquoise" => ["#40E0D0", "#00CED1", "#AFEEEE"],
   "Maroon" => ["#800000", "#8B0000", "#722F37", "#7C0A02"],
   "Indigo" => ["#4B0082", "#483D8B", "#6A5ACD", "#7B68EE"], // Небезопасный
   "Salmon" => ["#FA8072", "#FF8C69", "#FFA07A", "#FF7F50"], // Небезопасный
   "Peach" => ["#FFE5B4", "#FFDAB9", "#FFE4C4", "#FFDEAD"], // Небезопасный
];

// Функция для преобразования HEX в RGB
function hexToRgb($hex) {
    $hex = str_replace("#", "", $hex);
    if (strlen($hex) == 3) {
        $hex = $hex[0] . $hex[0] . $hex[1] . $hex[1] . $hex[2] . $hex[2];
    }
    $r = hexdec(substr($hex, 0, 2));
    $g = hexdec(substr($hex, 2, 2));
    $b = hexdec(substr($hex, 4, 2));
    return [$r, $g, $b];
}

// Функция для вычисления расстояния между двумя цветами в RGB
function colorDistance($color1, $color2) {
    list($r1, $g1, $b1) = $color1;
    list($r2, $g2, $b2) = $color2;
    return sqrt(pow($r1 - $r2, 2) + pow($g1 - $g2, 2) + pow($b1 - $b2, 2));
}

// Функция для определения ближайшего цвета
function findClosestColor($hex, $colorTable) {
    $inputRgb = hexToRgb($hex);
    $minDistance = PHP_FLOAT_MAX;
    $closestColor = "";

    foreach ($colorTable as $colorName => $hexValues) {
        foreach ($hexValues as $hexValue) {
            $tableRgb = hexToRgb($hexValue);
            $distance = colorDistance($inputRgb, $tableRgb);
            if ($distance < $minDistance) {
                $minDistance = $distance;
                $closestColor = $colorName;
            }
        }
    }

    return $closestColor;
}

/*
// Пример использования
$inputColor = "#EEEEEE";
$closestColor = findClosestColor($inputColor, $colorTable);
echo "<p>Ближайший цвет к $inputColor: $closestColor"; // Вывод: Ближайший цвет к #EEEEEE: Light Grey

$inputColor = "#DE2E5E";
$closestColor = findClosestColor($inputColor, $colorTable);
echo "<p>Ближайший цвет к <span style='font-weight: bold; color: $inputColor'>$inputColor: $closestColor</span>";

$inputColor = "#FFC799"; //Vivid Orange
$closestColor = findClosestColor($inputColor, $colorTable);
echo "<p>Ближайший цвет к <span style='font-weight: bold; color: $inputColor'>$inputColor: $closestColor</span>";

$inputColor = "#0F0019"; // Dark Indigo
$closestColor = findClosestColor($inputColor, $colorTable);
echo "<p>Ближайший цвет к <span style='font-weight: bold; color: $inputColor'>$inputColor: $closestColor</span>";
*/