<?php
require_once '../../../config.php';
ini_set('display_errors', 0);
error_reporting(0);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

ob_start();

// Ensure clean JSON response
header('Content-Type: application/json');
header('X-Content-Type-Options: nosniff');

$data = $_POST;

// Verify CSRF token with more robust checking
if (!isset($_SESSION['csrfToken']) || !isset($_POST['csrfToken']) || $_POST['csrfToken'] !== $_SESSION['csrfToken']) {
    // Clear output buffer
    ob_end_clean();
    echo json_encode(value: ["success" => false, "message" => "CSRF token invalid\n".
    "CSRF: ". $_SESSION['csrfToken'] .";\n"]);//.
    //"POST SCRF: ". $_POST['csrfToken']]);
    exit;
}

// Comprehensive input validation
if (!isset($data['user_id'])) {
    // Clear output buffer
    ob_end_clean();
    echo json_encode(["success" => false, "message" => "Missing required fields"]);
    exit;
}

// Validate input values
if (empty($data['user_id'])) {
    // Clear output buffer
    ob_end_clean();
    echo json_encode(["success" => false, "message" => "Empty required fields"]);
    exit;
}

try {
    $user_id = (int)$data['user_id'];

    $db = PROJECT_DIR.'/data/users.db';
    $manager = new UserManager($db);

    // Clear output buffer
    ob_end_clean();

    if ($manager->deleteUser($user_id)) {
        echo json_encode(["success" => true, "message" => "User with ID: $user_id deleted successfully"]);
    } else {
        echo json_encode(["success" => false, "message" => "User deletion failed"]);
    }
} catch (Exception $e) {
    // Clear output buffer
    ob_end_clean();

    // Log error securely
    error_log("Profile deletion error: " . $e->getMessage());
    echo json_encode([
        "success" => false,
        "message" => "An unexpected error occurred",
        "error_details" => $e->getMessage() // Optional: for debugging
    ]);
}
exit;