<?php
require_once '../../../config.php';
ini_set('display_errors', 0);
error_reporting(0);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Start output buffering to capture any unintended output
ob_start();


// Set response headers to return a clean JSON response
header('Content-Type: application/json');
header('X-Content-Type-Options: nosniff');

// Retrieve POST data
$data = $_POST;

// Verify CSRF token for security
if (!isset($_SESSION['csrfToken'], $data['csrfToken']) || $data['csrfToken'] !== $_SESSION['csrfToken']) {
    ob_end_clean(); // Clear any buffered output
    echo json_encode(["success" => false, "message" => "CSRF token invalid"]);
    exit;
}

// Validate required fields
if (!isset($data['profile_id'], $data['user_id'], $data['first_name'], $data['last_name'])) {
    ob_end_clean();
    echo json_encode(["success" => false, "message" => "Missing required fields"]);
    exit;
}

if (empty($data['profile_id']) || empty($data['user_id']) || empty(trim($data['first_name'])) || empty(trim($data['last_name']))) {
    ob_end_clean();
    echo json_encode(["success" => false, "message" => "Empty required fields"]);
    exit;
}

try {
    // Sanitize and prepare input values
    $profile_id = (int)$data['profile_id'];
    $role_id = (int)$data['role_id'];

    $user_id = (int)$data['user_id'];
    $first_name = trim($data['first_name']);
    $last_name = trim($data['last_name']);

    // Create an instance of ProfileManager using the database file path
    $db = PROJECT_DIR . '/data/users.db';
    $manager = new ProfileManager($db);

    // Attempt to update the profile details
    $result = $manager->updateProfile($profile_id, [
        'user_id' => $user_id,
        'first_name' => $first_name,
        'last_name' => $last_name,
        'role_id' => $role_id
    ]);

    ob_end_clean(); // Clear any buffered output

    if ($result) {
        echo json_encode(["success" => true, "message" => "Profile updated successfully"]);
    } else {
        echo json_encode(["success" => false, "message" => "Profile update failed"]);
    }
} catch (Exception $e) {
    ob_end_clean(); // Clear any buffered output
    error_log("Profile update error: " . $e->getMessage());
    echo json_encode([
        "success" => false,
        "message" => "An unexpected error occurred",
        "error_details" => $e->getMessage() // Optional: Remove error details in production
    ]);
}
exit;