<?php

ini_set('display_errors', 1);
error_reporting(1);

// Define the database file path
$dbFile = '../../../data/users.db';

// Check if the database file already exists
/*if (file_exists($dbFile)) {
    echo "Database file already exists. No need to create it again.";
    exit;
}*/

try {
    // Create (or open) the SQLite database
    $pdo = new PDO("sqlite:$dbFile");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // SQL to create the subscriptions table
    /*$createSubscriptionsTableSQL = "
        CREATE TABLE subscriptions (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            subscription_id INTEGER NOT NULL UNIQUE,
            subscription_name TEXT NOT NULL UNIQUE,
            subscription_days INTEGER NOT NULL DEFAULT 0,
            subscription_generations INTEGER NOT NULL DEFAULT 0,
            subscription_saves INTEGER NOT NULL DEFAULT 0,
            subscription_price FLOAT NOT NULL DEFAULT 0,
            subscription_templates INTEGER NOT NULL DEFAULT 0,
            description TEXT NOT NULL,
            active TINYINT DEFAULT 1
        );
    ";*/

    // Execute the SQL to create the subscriptions table
    /*$pdo->exec($createSubscriptionsTableSQL);*/

    // SQL to insert default subscriptions
    $insertSubscriptionsSQL = "
        INSERT INTO subscriptions (
            subscription_id,
            subscription_name,
            subscription_days,
            subscription_generations,
            subscription_saves,
            subscription_price,
            subscription_templates,
            description,
            active
        ) VALUES
        (1, 'admin', 0, 0, 0, 0, 0, 'System administrator with unlimited access', 1),
        (2, 'Demo', 0, 5, 1, 0, 0, 'Visitor with 5 generations and 1 save', 1),
        (3, 'Newcomer', 30, 300, 30, 50, 1, 'Standard user with 300 generation and 30 saves per 30 days', 1),
        (4, 'Business', 30, 900, 90, 199, 1, 'Standard user with 900 generation and 90 saves,  per 30 days', 1),
        (5, 'Developer', 30, 900, 90, 299, 3, 'Standard user with 900 generation and 90 saves per 30 days', 1)
    ";

    // Execute the SQL to insert default subscriptions
    $pdo->exec($insertSubscriptionsSQL);

    echo "Database, subscriptions table, and default subscriptions created successfully.";
} catch (PDOException $e) {
    echo "Error creating database or tables: " . $e->getMessage();
}
?>