<?php

const IMAGES_NUMBER = 5;
const TIMEOUT = 50;

sleep(TIMEOUT);
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Methods: GET, POST, OPTIONS"); // Разрешаем методы
header("Access-Control-Allow-Headers: Content-Type, Authorization"); // Разрешаем заголовки

$directory = './';
$images = glob($directory . '*.png');
$images = array_map(function($path) {
    return basename($path);
}, $images);

// Randomly select 3 unique images from the available images
$randomImages = [];
$imageCount = count($images);
$maxSelections = min(IMAGES_NUMBER, $imageCount);

// Use a while loop to ensure unique selections
while (count($randomImages) < $maxSelections) {
    $randomIndex = mt_rand(0, $imageCount - 1);
    $randomImage = $images[$randomIndex];

    // Only add if not already selected
    if (!in_array($randomImage, $randomImages)) {
        $randomImages[] = $randomImage;
    }
}

// Override $images with the randomly selected images
$images = $randomImages;


echo json_encode($images);