<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__.'/../../config.php';

require_once HELPERS_DIR . '/SubscriptionsHelper.php';

try {
    // Get the user ID from the session
    $userId = SessionHelper::get('FURBA_id');

    // Create SubscriptionsHelper instance
    $subscriptionsHelper = new SubscriptionsHelper();

    // Fetch user subscription
    $userSubscription = $subscriptionsHelper->getUserSubscription($userId);

    if ($userSubscription) {
        // Return subscription details as JSON
        echo json_encode([
            'success' => true,
            'subscription' => $userSubscription
        ]);
    } else {
        // No subscription found
        echo json_encode([
            'success' => false,
            'message' => 'No subscription found for this user'
        ]);
    }

} catch (PDOException $e) {
    // Handle database-specific errors
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    // Handle other exceptions
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}