<?php
require_once __DIR__.'/../../config.php';

//$input = file_get_contents('php://input');
//$data = json_decode($input, true);

// Set JSON header for API response
header('Content-Type: application/json');
header('X-Content-Type-Options: nosniff');

// Validate the user's fingerprint
if (!SessionHelper::validateFingerprint()) {
    // Fingerprint validation failed
    http_response_code(403);
    echo json_encode([
        'success' => false,
        'message' => 'Invalid fingerprint'
    ]);
    exit;
}

$tokenData = TokenHelper::verifyBearerToken();

if ($tokenData['status'] == 'refreshed') {
    SessionHelper::set('FurbaDesign', $tokenData['at']);
}

$_refreshed = (SessionHelper::updateSession() || $tokenData['status'] == 'refreshed');

if ($_refreshed) {
    http_response_code(200);
    echo json_encode([
        'success' => true,
        'at' => $tokenData['at'],
        'message' => 'Refreshed'
    ]);
    exit;
}


http_response_code(200);
echo json_encode([
    'success' => true,
    'message' => 'OK',
]);
exit;