<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__.'/../../config.php';

// Set JSON header for API response
header('Content-Type: application/json');
header('X-Content-Type-Options: nosniff');

// Handle user login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    try {

        $db = PROJECT_DIR . '/data/users.db';
        $authorizer = new UserAuthorizer($db);
        // Use the new checkUser method to handle authentication
        $result = $authorizer->checkUser($_POST['username'] ?? '', $_POST['password'] ?? '');

        if ($result['success']) {

            $userId = $result['user']['id']?? 0;
            $userRole = $result['user']['role'] ?? 'user';


            // Set authentication-related session data
            SessionHelper::set('FURBA_id', $userId);
            SessionHelper::set('FURBA_role', $userRole);

            $token = TokenHelper::createToken(3600);
            SessionHelper::set('token', $token);

            // Successful login response with token
            http_response_code(200);
            echo json_encode([
                'success' => true,
                'message' => 'Login successful',
            ]);
            exit;

        } else {
            http_response_code(401);
            echo json_encode($result);
            exit;
        }

    } catch (Exception $e) {
        // Token generation error
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'message' => 'Login failed',
            'error' => $e->getMessage()
        ]);
        exit;
    }
} else {
    http_response_code(200);
    echo json_encode([
        'success' => false,
        'message' => 'No data provided',
    ]);
    exit;
}