<?php
class ToolsHelper {
    public static function idString($id, $length = 8, $pad = '0'): string
    {
        return str_pad((string) $id, $length, $pad, STR_PAD_LEFT);
    }

    public static function createDirectory(string $directoryName, string $basePath, int $permissions = 0777): bool {
        // Construct the full path of the directory
        $fullPath = $basePath . DIRECTORY_SEPARATOR . $directoryName;

        // Check if the directory already exists
        if (is_dir($fullPath)) {
            // If the directory exists, return false
            return false;
        }

        // Try to create the directory
        try {
            // Create the directory with the specified permissions
            mkdir($fullPath, $permissions, true);
            // If the directory was created successfully, return true
            return true;
        } catch (Exception $e) {
            // If an error occurred, print the error message and return false
            echo "Error creating directory: " . $e->getMessage() . "\n";
            return false;
        }
    }
}