<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

/**
 * Save generated image to a specified folder.
 *
 * @param string $jsonResponse The JSON response containing the base64 image string.
 * @param int|string $userId The user ID for folder path.
 * @return string|false The complete file path if successful, false on failure.
 */
function saveGeneratedImage($data, $jobId = null) {

    if (empty($jobId)) {
        error_log("No job ID provided.");
        return false;
    }

    // Check that the response has the correct structure and status
    if (!isset($data['output']['message']) || !isset($data['status']) || $data['status'] !== 'COMPLETED') {
        error_log("Invalid JSON response structure or status is not COMPLETED.");
        return false;
    }

    // Retrieve the base64-encoded image string from the response
    $base64Image = $data['output']['message'];

    // Decode the base64 image data to binary.
    $imageData = base64_decode($base64Image);
    if ($imageData === false) {
        error_log("Failed to decode the base64 image data.");
        return false;
    }

    /*
    // Добавляем meta-информацию к PNG.
    try {
        $pngWithMeta = Helpers\PNGMeta::addMetaData($imageData, $metaData);
    } catch (\Exception $e) {
        // die("Ошибка: " . $e->getMessage());
        $errorMessage = "Error adding meta data to image at " . date('Y-m-d H:i:s') . ": " . $e->getMessage() . "\n";
        file_put_contents(__DIR__ . "/error_log.txt", $errorMessage, FILE_APPEND);
    }
    */

    // Define the target directory relative to the current file.
    // Adjust the __DIR__ path if needed according to your project structure.
    $dirPath = PROJECT_DIR . "/data/generations";

    // Create the directory if it does not exist.
    if (!is_dir($dirPath)) {
        if (!mkdir($dirPath, 0777, true)) {
            error_log("Failed to create directory: $dirPath");
            return false;
        }
    }

    // Generate a unique file name using the current timestamp.
    $fileName =  $jobId .".png";
    $filePath = $dirPath . "/" . $fileName;

    // Write the binary image data to the file.
    if (file_put_contents($filePath, $imageData) === false) {
        error_log("Failed to write image data to file: $filePath");
        return false;
    }

    saveMetaInformation($jobId, $dirPath, $data);

    // Return the file path to confirm success.
    return $filePath;
}

function saveMetaInformation($jobId, $dirPath, &$data = []) {

    if (empty($jobId) || empty($dirPath) || empty($data)) {
        return;
    }

    if (isset($data['output'])) {
        unset($data['output']);
    }

    // Meta-информация для добавления.
    $metaData = [
        'Comment' => 'This image was generated using FURBA tool',
        'Author'  => 'Markelangelo\' GPU Client v002',
        'Created' => date('Y-m-d H:i:s'),
        'JobInfo' => $data,
    ];

    // Define the JSON file path based on the directory and job ID.
    $jsonFilePath = $dirPath . "/" . $jobId . ".json";

    // Encode the meta-data array into a JSON string with pretty print.
    $jsonData = json_encode($metaData, JSON_PRETTY_PRINT);

    // Check if the JSON encoding was successful.
    if ($jsonData === false) {
        error_log("Failed to encode metaData to JSON at " . date('Y-m-d H:i:s'));
    } else {
        // Save the JSON data to the file.
        if (file_put_contents($jsonFilePath, $jsonData) === false) {
            error_log("Failed to write meta data to file: $jsonFilePath at " . date('Y-m-d H:i:s'));
        }
    }
}

// Example usage:
/*
$jsonResponse = '{
    "status": "COMPLETED",
    "output": {
        "message": "iVBORw0KGgoAAAANSUhEUgAABAAAAAQACAIAAADwf7zUAAEAAElEQVR4X... (base64 data)"
    },
    "completedAt": "2025-02-25 05:23:03"
}';
$userId = 123; // Replace with your user ID

$result = saveGeneratedImage($jsonResponse, $userId);
if ($result !== false) {
    echo "Image saved successfully: " . $result;
} else {
    echo "Failed to save image.";
}
*/