<?php
// Разрешаем CORS для конкретного домена
$origin = $_SERVER['HTTP_ORIGIN'] ?? ''; // Получаем значение заголовка Origin

// Проверяем, что запрос пришёл с разрешённого домена
if (preg_match('/^https:\/\/ankkait\.yachtering\.eu$/', $origin)) {
    header("Access-Control-Allow-Origin: $origin"); // Устанавливаем Access-Control-Allow-Origin
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS"); // Разрешаем методы
    header("Access-Control-Allow-Headers: Content-Type, Authorization"); // Разрешаем заголовки
} else {
    // Если домен не разрешён, завершаем выполнение скрипта
    http_response_code(403); // Ответ 403 Forbidden
    echo json_encode(['error' => 'CORS request not allowed for this origin.']);
    exit;
}

// Обработка preflight-запросов (OPTIONS)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204); // Ответ без тела
    exit;
}