<?php
require_once '../../../config.php';
?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Interface</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <script src="/furba/www/assets/vendor/jquery/jquery.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p" crossorigin="anonymous"></script>
    <style>
        body {
            padding: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <ul class="nav nav-tabs">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#profiles" role="tab" aria-controls="profiles" aria-selected="true">Profiles</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#create-profile" role="tab" aria-controls="create-profile" aria-selected="false">Create Profile</a>
                    </li>
                        <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="tab" href="#update-profile" role="tab" aria-controls="update-profile" aria-selected="false">Update Profile</a>
                        </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#delete-profile" role="tab" aria-controls="delete-profile" aria-selected="false">Delete Profile</a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="profiles">
                        <h2>Profiles</h2>
                        <div class="row g-4" id="profiles-container">
                        <!-- Профили будут динамически добавляться сюда -->
                        </div>
                    </div>
                    <div class="tab-pane" id="create-profile">
                        <h2>Create Profile</h2>
                        <form id="create-profile-form">
                            <div class="mb-3">
                                <label for="user-id" class="form-label">User  ID</label>
                                <input type="text" class="form-control" id="user-id" name="user_id">
                            </div>
                            <div class="mb-3">
                                <label for="first-name" class="form-label">First Name</label>
                                <input type="text" class="form-control" id="first-name" name="first_name">
                            </div>
                            <div class="mb-3">
                                <label for="last-name" class="form-label">Last Name</label>
                                <input type="text" class="form-control" id="last-name" name="last_name">
                            </div>
                            <button type="submit" class="btn btn-primary">Create Profile</button>
                        </form>
                    </div>
                    <div class="tab-pane" id="update-profile">

                        <form id="update-profile-form">
                            <div class="mb-3">
                                <label for="profile-id-update" class="form-label">Profile ID</label>
                                <input type="text" class="form-control" id="profile-id-update" name="profile_id">
                            </div>
                            <div class="mb-3">
                                <label for="user-id-update" class="form-label">User ID</label>
                                <input type="text" class="form-control" id="user-id-update" name="user_id">
                            </div>
                            <div class="mb-3">
                                <label for="first-name-update" class="form-label">First Name</label>
                                <input type="text" class="form-control" id="first-name-update" name="first_name">
                            </div>
                            <div class="mb-3">
                                <label for="last-name-update" class="form-label">Last Name</label>
                                <input type="text" class="form-control" id="last-name-update" name="last_name">
                            </div>
                            <div class="mb-3">
                                <label for="role-id-update" class="form-label">Role ID</label>
                                <input type="text" class="form-control" id="role-id-update" name="role_id">
                            </div>
                            <button type="submit" class="btn btn-primary">Update Profile</button>
                        </form>

                    </div>
                    <div class="tab-pane" id="delete-profile">
                        <h2>Delete Profile</h2>
                        <form id="delete-profile-form">
                            <div class="mb-3">
                                <label for="profile-id-delete" class="form-label">Profile ID</label>
                                <input type="text" class="form-control" id="profile-id-delete" name="profile_id">
                            </div>
                            <button type="submit" class="btn btn-primary">Delete Profile</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        function deleteProfile(profileId) {
            $.ajax({
                type: "POST",
                url: "delete_profile.php",
                data: {
                    profile_id: profileId,
                    csrfToken: '<?=$_SESSION['csrfToken']?>'
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        alert(response.message);
                        location.reload();
                    } else {
                        alert("Error: " + response.message);
                    }
                },
                error: function(xhr, status, error) {
                    console.error("AJAX Error:", status, error);
                    console.log("Response Text:", xhr.responseText);
                    alert("Error deleting profile. Check console for details.");
                }
            });
        }

        $(document).ready(function() {
            // Load profiles table
            $.ajax({
                type: "GET",
                url: "load_profiles.php",
                dataType: "json",
                success: function(data) {
                    $("#profiles-container").empty(); // Очистить контейнер перед загрузкой
                    $.each(data, function(index, profile) {
                        $("#profiles-container").append(`
                            <div class="col-12 col-md-6 col-lg-4" data-profile-id="${profile.id}">
                                <div class="card h-100 shadow-sm">
                                    <div class="card-body">
                                        <h5 class="card-title">Profile #${profile.id}</h5>
                                        <div class="mb-2">
                                            <strong>User ID:</strong> ${profile.user_id}
                                        </div>
                                        <div class="mb-2">
                                            <strong>Name:</strong> ${profile.first_name} ${profile.last_name}
                                        </div>
                                        <div class="mb-2">
                                            <strong>Role ID:</strong> ${profile.role_id}
                                        </div>
                                    </div>
                                    <div class="card-footer bg-transparent d-flex justify-content-between">
                                        <button class="btn btn-sm btn-outline-primary edit-profile"
                                            data-id="${profile.id}"
                                            data-user-id="${profile.user_id}"
                                            data-first-name="${profile.first_name}"
                                            data-last-name="${profile.last_name}"
                                            data-role-id="${profile.role_id}">
                                            <i class="bi bi-pencil me-1"></i>Edit
                                        </button>
                                        <button class="btn btn-sm btn-outline-danger delete-profile"
                                            data-id="${profile.id}">
                                            <i class="bi bi-trash me-1"></i>Delete
                                        </button>
                                    </div>
                                </div>
                            </div>
                        `);
                    });
                }
            });

            $(document).on('click', '.edit-profile', function() {
                var profileId = $(this).data('id');
                var userId = $(this).data('user-id');
                var firstName = $(this).data('first-name');
                var lastName = $(this).data('last-name');
                var roleId = $(this).data('role-id');

                // Заполняем форму редактирования данными профиля
                $("#profile-id-update").val(profileId);
                $("#profile-id-update").prop("disabled", true);
                $("#user-id-update").val(userId);
                $("#first-name-update").val(firstName);
                $("#last-name-update").val(lastName);
                $("#role-id-update").val(roleId);

                // Переключаемся на вкладку редактирования
                $('a[href="#update-profile"]').tab('show');
            });

            // Create profile form submission
            $("#create-profile-form").submit(function(event) {
                event.preventDefault();
                var userId = $("#user-id").val();
                var firstName = $("#first-name").val();
                var lastName = $("#last-name").val();

                $.ajax({
                    type: "POST",
                    url: "create_profile.php",
                    data: {
                        user_id: userId,
                        first_name: firstName,
                        last_name: lastName,
                        csrfToken: '<?=$_SESSION['csrfToken']?>'
                    },
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            alert(response.message);
                            location.reload();
                        } else {
                            alert("Error: " + response.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error("AJAX Error:", status, error);
                        console.log("Response Text:", xhr.responseText);
                        alert("Error creating profile. Check console for details.");
                    }
                });
            });

            $("#update-profile-form").submit(function(event) {
                event.preventDefault(); // Prevent the default form submission

                // Retrieve input values for profile update
                var profileId = $("#profile-id-update").val();
                var userId = $("#user-id-update").val();
                var firstName = $("#first-name-update").val();
                var lastName = $("#last-name-update").val();
                var roleId = $("#role-id-update").val();

                // Send AJAX POST request for updating profile data
                $.ajax({
                    type: "POST",
                    url: "update_profile.php",
                    data: {
                        profile_id: profileId,
                        user_id: userId,
                        first_name: firstName,
                        last_name: lastName,
                        role_id: roleId,
                        csrfToken: '<?=$_SESSION['csrfToken']?>'
                    },
                    dataType: "json",
                    success: function(response) {
                        // If the update is successful, notify the user and refresh the page.
                        if (response.success) {
                            alert(response.message);
                            location.reload();
                        } else {
                            alert("Error: " + response.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error("AJAX Error:", status, error);
                        console.log("Response Text:", xhr.responseText);
                        alert("Error updating profile. Check console for details.");
                    }
                });
            });

            // Delete profile form submission
            $(document).on('click', '.delete-profile', function() {
                var profileId = $(this).data('id');

                if (confirm('Are you sure you want to delete this profile?')) {
                    deleteProfile(profileId);
                }
            });
            $("#delete-profile-form").submit(function(event) {
                event.preventDefault();
                var profileId = $("#profile-id-delete").val();
                if (confirm('Are you sure you want to delete this profile?')) {
                    deleteProfile(profileId);
                }
            });
        });
    </script>
</body>
</html>