<?php
// Define the database file path
$dbFile = '../../../data/users.db';

try {
    // Create (or open) the SQLite database
    $pdo = new PDO("sqlite:$dbFile");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Check if the 'users' table exists
    $stmt = $pdo->query("SELECT name FROM sqlite_master WHERE type='table' AND name='users';");
    $usersTableExists = $stmt->fetchColumn();

    // Check if the 'profiles' table exists
    $stmt = $pdo->query("SELECT name FROM sqlite_master WHERE type='table' AND name='profiles';");
    $profilesTableExists = $stmt->fetchColumn();

    if (!$usersTableExists) {
        // SQL to create the users table
        $createUsersTableSQL = "
            CREATE TABLE users (
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                username TEXT NOT NULL UNIQUE,
                password TEXT NOT NULL,
                email TEXT NOT NULL UNIQUE
            );
        ";
        $pdo->exec($createUsersTableSQL);
        echo "Users table created successfully.\n";
    } else {
        echo "Users table already exists. Checking for updates...\n";
        // Add any necessary updates to the users table here
        // For example, adding a new column:
        // $pdo->exec("ALTER TABLE users ADD COLUMN new_column TEXT;");
    }

    if (!$profilesTableExists) {
        // SQL to create the profiles table
        $createProfilesTableSQL = "
            CREATE TABLE profiles (
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                user_id INTEGER NOT NULL,
                role_id INTEGER NOT NULL DEFAULT 3,
                first_name TEXT,
                last_name TEXT,
                dt DATETIME DEFAULT CURRENT_TIMESTAMP,
                FOREIGN KEY (user_id) REFERENCES users (id)
            );
        ";
        $pdo->exec($createProfilesTableSQL);
        echo "Profiles table created successfully.\n";
    } else {
        echo "Profiles table already exists. Checking for updates...\n";
        // Add any necessary updates to the profiles table here
        // For example, adding a new column:
        // $pdo->exec("ALTER TABLE profiles ADD COLUMN new_column TEXT;");
    }

    echo "Database and tables are ready.";
} catch (PDOException $e) {
    echo "Error creating or updating database or tables: " . $e->getMessage();
}