<?php
// Define the database file path
$dbFile = '../../data/users.db';

// Check if the database file already exists
if (file_exists($dbFile)) {
    echo "Database file already exists. No need to create it again.";
    exit;
}

try {
    // Create (or open) the SQLite database
    $pdo = new PDO("sqlite:$dbFile");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // SQL to create the users table
    $createUsersTableSQL = "
        CREATE TABLE users (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            username TEXT NOT NULL UNIQUE,
            password TEXT NOT NULL,
            email TEXT NOT NULL UNIQUE
        );
    ";

    // SQL to create the profiles table
    $createProfilesTableSQL = "
        CREATE TABLE profiles (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            user_id INTEGER NOT NULL,
            first_name TEXT,
            last_name TEXT,
            dt DATETIME DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (user_id) REFERENCES users (id)
        );
    ";

    // Execute the SQL statements to create the tables
    $pdo->exec($createUsersTableSQL);
    $pdo->exec($createProfilesTableSQL);

    echo "Database and tables created successfully.";
} catch (PDOException $e) {
    echo "Error creating database or tables: " . $e->getMessage();
}
?>